﻿/*
VERSION:	1.8

USAGE:
	#include "tileWalk.as"
	myWalk_obj = makeTileWalk( my_mc );
	
SETTINGS:
	walkSpeed			How many seconds it takes to walk 1 tile		(smaller = faster)		(default: 0.13  (RpgMaker)
	
NOTES:
	This system has hooks for these collision and sprite systems:
		MakeSprite()			(Sprite system 1 - RpgMaker)
		TileWalkCollision	
	
ADDING COLLISION:
	A collision system can be added like this:
		walk_obj.collision = new Collision( player_mc, walk_obj, collision_array, -8, -8 );
	The walk_obj is this walk system.
*/
makeTileWalk = function( player_mc, playerSprite_mc )
{
	// create system container
	var _this = new Object();
	
	// Settings
	_this.walkSpeed = 0.2;		// How many seconds it takes to walk 1 tile  (smaller = faster)
	_this.playerSprite_mc = playerSprite_mc;
	
	// initial animation
	_this.playerSprite_mc.setAnim( false );
	
	//default walk buttons.  This allows the keys to be changed externally.
	_this.up_key = Key.UP;
	_this.down_key = Key.DOWN;
	_this.left_key = Key.LEFT;
	_this.right_key = Key.RIGHT;
	
	
	
	// create loop
	_this.loop = function()
	{
		// if movement is enabled
		if(!_this.disableKeys)
		{
			// Define movement
			if(Key.isDown(_this.up_key))
			{
				_this.xVel = 0;
				_this.yVel = -1;
				_this.playerSprite_mc.setDirection("up");
			}// if:  key up
			else if(Key.isDown(_this.down_key))
			{
				_this.xVel = 0;
				_this.yVel = 1;
				_this.playerSprite_mc.setDirection("down");
			}// if:  key down
			else if(Key.isDown(_this.left_key))
			{
				_this.xVel = -1;
				_this.yVel = 0;
				_this.playerSprite_mc.setDirection("left");
			}// if:  key left
			else if(Key.isDown(_this.right_key))
			{
				_this.xVel = 1;
				_this.yVel = 0;
				_this.playerSprite_mc.setDirection("right");
			}// if:  key right
			
			
			
			if(Key.isDown(_this.up_key)  ||
				Key.isDown(_this.down_key)  ||
				Key.isDown(_this.left_key)  ||
				Key.isDown(_this.right_key) )
			{
				// Apply externally-defined collision
				_this.collision.run();
			}// if:  key right
			
			
			
			// Do movement
			if(_this.xVel || _this.yVel)
			{
				_this.playerSprite_mc.setAnim( true );
				// disable key detection
				_this.disableKeys = true;
				
				
				// tween movement
				var xStart = Math.round(player_mc._x / 16) * 16;
				var yStart = Math.round(player_mc._y / 16) * 16;
				xStart += _this.xVel * (Math.round( 16 / (30*_this.walkSpeed) ));		// offset for seamless multi-step motion
				yStart += _this.yVel * (Math.round( 16 / (30*_this.walkSpeed) ));		// offset for seamless multi-step motion
				
				var xDest = Math.floor(player_mc._x / 16);
				var yDest = Math.floor(player_mc._y / 16);
				xDest += _this.xVel;
				yDest += _this.yVel;
				xDest *= 16;
				yDest *= 16;

				var easing = mx.transitions.easing.None.easeNone;
				_this.xTween = new mx.transitions.Tween( player_mc, "_x", easing, xStart, xDest, _this.walkSpeed, true);
				_this.yTween = new mx.transitions.Tween( player_mc, "_y", easing, yStart, yDest, _this.walkSpeed, true);
				
				
				// enable key detection
				if(_this.xVel)
				{
					_this.xTween.onMotionFinished = function()
					{
						_this.disableKeys = false;
						if(_this.isPaused == undefined  ||  _this.isPaused==false){
							_this.loop();
						}else{
							_this.playerSprite_mc.setAnim( false );
						}
					}// motion finished()
					_this.yTween.onMotionFinished = function(){}
				}// if:  horz movement
				else if(_this.yVel)
				{
					_this.xTween.onMotionFinished = function(){}
					_this.yTween.onMotionFinished = function()
					{
						_this.disableKeys = false;
						if(_this.isPaused == undefined  ||  _this.isPaused==false){
							_this.loop();
						}else{
							_this.playerSprite_mc.setAnim( false );
						}
					}// motion finished()
				}// if:  vert movement
				
				
				
				// reset velocities
				_this.xVel = 0;
				_this.yVel = 0
			}// if:  arrow key is pressed
			else
			{// if:  not moving
				_this.playerSprite_mc.setAnim( false );
			}
		}// if:  keys are enabled
	}// loop()
	
	
	
	// make this loop
	_this.loopInterval = setInterval( _this.loop, 1000/30 ); 
	
	
	
	// return a reference to this system
	return _this;
}// makeTileWalk()
